//%attributes = {}
// Method: ld_ ALL_ARR_CALCULATE_INIT
// 2006.02.21-16:58:21 / Pasi Mankinen
// © Copyright 2006 Manage Applications
// Purpose: 
// initializes critical date arrays for recalculation
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($ld_lAllArrIndex; $ld_lPos; $ld_lCount; $ld_lPoductArrSize; $ld_lPodLotArrSize; $ld_lPhaseArrSize; $ld_lLgArrSize)
//COMPILER_ld_all_arr

ARRAY TEXT:C222(ld_atProductToCalculate; 0)
ARRAY TEXT:C222(ld_atProdLotToCalculate; 0)
ARRAY TEXT:C222(ld_atPhaseToCalculate; 0)
ARRAY TEXT:C222(ld_atLgToCalculate; 0)

If (prnc_ CriticalDateAllRecalc=kTrue)
	prnc_ ALL_RECALC_PROD_ARR_FILL(->ld_all_atProduct_id)  //;->ld_all_asWork_Phase_State) `slould not copy finished prod?
End if 

If (ld_lCalculateCriticalDate=kTrue)
	
	//PM: 2006-08-18: save old values before nulling them
	COPY ARRAY:C226(ld_all_asProduction_Lot__work_; ld_all_asProduction_Lot__w_Orig)
	
	COPY ARRAY:C226(ld_all_adCriticalDate; ld_all_adCriticalDateOrig)
	COPY ARRAY:C226(ld_all_adCriticalDateDelayed; ld_all_adCriticalDateDelOrig)
	COPY ARRAY:C226(ld_all_adCriticalDateReal; ld_all_adCriticalDateRealOrig)
	
	COPY ARRAY:C226(ld_all_adPhaseCriticalStartDate; ld_all_adPhaseCriticalStartDaOr)
	COPY ARRAY:C226(ld_all_ahPhaseCriticalStartTime; ld_all_ahPhaseCriticalStartTiOr)
	COPY ARRAY:C226(ld_all_adPhaseCriticalDate; ld_all_adPhaseCriticalDateOrig)
	COPY ARRAY:C226(ld_all_ahPhaseCriticalTime; ld_all_ahPhaseCriticalTimeOrig)
	COPY ARRAY:C226(ld_all_adPhaseCriticalExtraDate; ld_all_adPhaseCriticalExtraDaOr)
	COPY ARRAY:C226(ld_all_ahPhaseCriticalExtraTime; ld_all_ahPhaseCriticalExtraTiOr)
	COPY ARRAY:C226(ld_all_adPhaseCriticalDateDelay; ld_all_adPhaseCriticalDateDelOr)
	
	COPY ARRAY:C226(ld_all_arUrgencyIndex; ld_all_arUrgencyIndexOrig)
	//COPY ARRAY(ld_all_alCriticalDateDiff;ld_all_alCriticalDateDiffOrig) 
End if 

$ld_lCount:=Size of array:C274(ld_all_adCriticalDate)

prnc_ CALCULATE_ARR_GET(->ld_atProductToCalculate; ->ld_atProdLotToCalculate; ->ld_atPhaseToCalculate; ->ld_atLgToCalculate)
$ld_lPoductArrSize:=Size of array:C274(ld_atProductToCalculate)
$ld_lPodLotArrSize:=Size of array:C274(ld_atProdLotToCalculate)
$ld_lLgArrSize:=Size of array:C274(ld_atLgToCalculate)
$ld_lPhaseArrSize:=Size of array:C274(ld_atPhaseToCalculate)

If (False:C215)  //for trace
	$ld_lAllArrIndex:=Find in array:C230(ld_all_adCriticalDate; !00-00-00!)  //find NEXT zero  
	$ld_lAllArrIndex:=Find in array:C230(ld_all_adPhaseCriticalDate; !00-00-00!)  //find NEXT zero  
End if 

For ($ld_lAllArrIndex; 1; $ld_lCount)
	ld_all_alCriticalDateSave{$ld_lAllArrIndex}:=0
	Case of 
		: (ld_WoStateIsOpen(ld_all_asProduction_Lot{$ld_lAllArrIndex})=kFalse)
			IDLE:C311  //do not mark to be calculated
		: (prnc_ CriticalDateAllRecalc=kTrue)
			ld_all_adCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
			ld_all_alCriticalDateSave{$ld_lAllArrIndex}:=1+2  //set first and second bit to 1, clear others
			ld_all_adPhaseCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
			//ME: 2006-03-08 do not change the fixed values
			If (ld_all_arUrgencyIndex{$ld_lAllArrIndex}=0)
				ld_all_arUrgencyIndex{$ld_lAllArrIndex}:=1000001  //set to not calculated
			End if 
		Else 
			
			If ((ld_all_adCriticalDate{$ld_lAllArrIndex}#!00-00-00!) & ($ld_lPoductArrSize>0))  //optimization to avoid possibly slow Find in array
				$ld_lPos:=Find in array:C230(ld_atProductToCalculate; ld_all_atProduct_id{$ld_lAllArrIndex})
				If ($ld_lPos>0)  //is in set of products to calculate again
					ld_all_adCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
				End if 
			End if 
			
			If ((ld_all_adCriticalDate{$ld_lAllArrIndex}#!00-00-00!) & ($ld_lPodLotArrSize>0))  //optimization to avoid possibly slow Find in array
				$ld_lPos:=Find in array:C230(ld_atProdLotToCalculate; ld_all_asProduction_Lot{$ld_lAllArrIndex})
				If ($ld_lPos>0)  //is in set of products to calculate again
					ld_all_adCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
				End if 
			End if 
			
			If (ld_all_adCriticalDate{$ld_lAllArrIndex}=!00-00-00!)  //must recalculate also phase critical dates
				ld_all_adPhaseCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
				//ME: 2006-03-08 do not change the fixed values
				If (ld_all_arUrgencyIndex{$ld_lAllArrIndex}=0)
					ld_all_arUrgencyIndex{$ld_lAllArrIndex}:=1000001  //set to not calculated
				End if 
				ld_all_alCriticalDateSave{$ld_lAllArrIndex}:=1+2  //set first and second bit to 1, clear others
			End if 
			
			If (((ld_all_adPhaseCriticalDate{$ld_lAllArrIndex}#!00-00-00!) | (ld_all_adCriticalDate{$ld_lAllArrIndex}#!00-00-00!)) & ($ld_lLgArrSize>0))  //optimization to avoid possibly slow Find in array
				$ld_lPos:=Find in array:C230(ld_atLgToCalculate; ld_all_asWork_Load_Group_id{$ld_lAllArrIndex})
				If ($ld_lPos>0)  //is in set of load groups to calculate again
					
					ld_all_adCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
					ld_all_alCriticalDateSave{$ld_lAllArrIndex}:=1+2  //set first and second bit to 1, clear others
					ld_all_adPhaseCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
					//ME: 2006-03-08 do not change the fixed values
					If (ld_all_arUrgencyIndex{$ld_lAllArrIndex}=0)
						ld_all_arUrgencyIndex{$ld_lAllArrIndex}:=1000001  //set to not calculated
					End if 
				End if 
			End if 
			
			If ((ld_all_adPhaseCriticalDate{$ld_lAllArrIndex}#!00-00-00!) & ($ld_lPhaseArrSize>0))  //optimization to avoid possibly slow Find in array
				$ld_lPos:=Find in array:C230(ld_atPhaseToCalculate; ld_all_asProduction_Lot__work_{$ld_lAllArrIndex})
				If ($ld_lPos>0)  //is in set of load groups to calculate again
					ld_all_adPhaseCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
					If (ld_all_alCriticalDateSave{$ld_lAllArrIndex}=0)
						ld_all_alCriticalDateSave{$ld_lAllArrIndex}:=2
					End if 
				End if 
			End if 
			
	End case 
End for 

If (prnc_ CriticalDateAllRecalc=kFalse)
	//if some phase critical date is zero then zero all 
	//phase critical dates for that production lot
	$ld_lPos:=1
	Repeat 
		$ld_lPos:=Find in array:C230(ld_all_adPhaseCriticalDate; !00-00-00!; $ld_lPos)  //find NEXT zero
		If ($ld_lPos<1)
			//idle
		Else 
			$ld_lAllArrIndex:=$ld_lPos  //set backwards all same prod lot phase critical dates to zero
			
			If (ld_WoStateIsOpen(ld_all_asProduction_Lot{$ld_lAllArrIndex})=kTrue)
				While ($ld_lAllArrIndex>1)
					$ld_lAllArrIndex:=$ld_lAllArrIndex-1  //previous
					If (ld_all_asProduction_Lot{$ld_lAllArrIndex}=ld_all_asProduction_Lot{$ld_lPos})
						ld_all_adPhaseCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
						If (ld_all_alCriticalDateSave{$ld_lAllArrIndex}=0)
							ld_all_alCriticalDateSave{$ld_lAllArrIndex}:=2
						End if 
					Else 
						$ld_lAllArrIndex:=-1  //different prod lot, exit while loop
					End if 
				End while 
				
				$ld_lAllArrIndex:=$ld_lPos  //set forward all same prod lot phase critical dates to zero
				While ($ld_lAllArrIndex<$ld_lCount)
					$ld_lAllArrIndex:=$ld_lAllArrIndex+1  //next
					If (ld_all_asProduction_Lot{$ld_lAllArrIndex}=ld_all_asProduction_Lot{$ld_lPos})
						ld_all_adPhaseCriticalDate{$ld_lAllArrIndex}:=!00-00-00!
						If (ld_all_alCriticalDateSave{$ld_lAllArrIndex}=0)
							ld_all_alCriticalDateSave{$ld_lAllArrIndex}:=2
						End if 
					Else 
						$ld_lPos:=$ld_lAllArrIndex-1  //set new pos to start find (later $ld_lPos:=$ld_lPos+1)
						$ld_lAllArrIndex:=$ld_lCount+1  //different prod lot, exit while loop
					End if 
				End while 
			End if 
			
			$ld_lAllArrIndex:=$ld_lPos  //for tracing last found/fixed index
			$ld_lPos:=$ld_lPos+1  //find from next pos
			
		End if 
	Until ($ld_lPos<1)
End if 

//ARRAY TEXT(ld_atProductToCalculate;0)  `this must stay
ARRAY TEXT:C222(ld_atProdLotToCalculate; 0)
ARRAY TEXT:C222(ld_atLgToCalculate; 0)
ARRAY TEXT:C222(ld_atPhaseToCalculate; 0)

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
